<?php
require_once 'config.php';
require_once 'utils/pdf_parser.php';
require_once 'utils/vde_scraper.php';

header('Content-Type: application/json; charset=UTF-8');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['error' => 'Método no permitido']);
    exit;
}

if (!isset($_FILES['pdf'])) {
    echo json_encode(['error' => 'No se recibió archivo PDF']);
    exit;
}

$file = $_FILES['pdf'];

if ($file['error'] !== UPLOAD_ERR_OK) {
    echo json_encode(['error' => 'Error al subir archivo']);
    exit;
}

if ($file['type'] !== 'application/pdf') {
    echo json_encode(['error' => 'El archivo debe ser PDF']);
    exit;
}

$filename = uniqid('pdf_') . '.pdf';
$filepath = UPLOAD_DIR . $filename;

if (!move_uploaded_file($file['tmp_name'], $filepath)) {
    echo json_encode(['error' => 'Error al guardar archivo']);
    exit;
}

try {
    $parser = new VDEPdfParser($filepath);
    $productos = $parser->extraerProductos();
    
    if (empty($productos)) {
        echo json_encode(['error' => 'No se encontraron productos en el PDF']);
        exit;
    }
    
    // Enriquecer con datos de VDE
    foreach ($productos as &$prod) {
        if (!empty($prod['codigo'])) {
            // Obtener URL de imagen
            $imagenUrl = obtenerImagenVDE($prod['codigo']);
            if ($imagenUrl) {
                $prod['imagen_url'] = $imagenUrl;
            }
            
            // Obtener especificaciones
            $especificaciones = obtenerEspecificacionesVDE($prod['codigo']);
            $prod['especificaciones'] = $especificaciones;
            
            // Obtener descripción y marca del sitio VDE si no viene en PDF
            $url = VDE_BASE . '/' . slugify($prod['codigo']) . '.html';
            $ch = curl_init($url);
            curl_setopt_array($ch, [
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_TIMEOUT => 10,
                CURLOPT_SSL_VERIFYPEER => false,
                CURLOPT_USERAGENT => 'Mozilla/5.0'
            ]);
            $html = curl_exec($ch);
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
            
            if ($httpCode === 200 && $html) {
                libxml_use_internal_errors(true);
                $dom = new DOMDocument();
                @$dom->loadHTML(mb_convert_encoding($html, 'HTML-ENTITIES', 'UTF-8'));
                $xpath = new DOMXPath($dom);
                
                // Descripción del título de la página
                $title = $xpath->query('//span[@class="base"]');
                if ($title->length) {
                    $prod['descripcion'] = trim($title->item(0)->textContent);
                }
                
                // Marca
                $marca = $xpath->query('//td[@data-th="Marca"]');
                if ($marca->length) {
                    $prod['marca'] = trim($marca->item(0)->textContent);
                }
            }
        }
    }
    
    echo json_encode([
        'success' => true,
        'productos' => $productos,
        'filename' => $filename
    ]);
    
} catch (Exception $e) {
    echo json_encode(['error' => 'Error al procesar PDF: ' . $e->getMessage()]);
}
?>