<?php
require_once 'auth.php';
header('Content-Type: text/html; charset=UTF-8');  // <— NUEVO

if (!empty($_SESSION['logged_in'])) {
    header('Location: index.php');
    exit;
}

$error = processLogin();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Acceso - Cotizador VAELSA</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Arial, sans-serif;
            background: linear-gradient(135deg, #1e3a8a 0%, #1e40af 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .login-box {
            background: white;
            border-radius: 20px;
            box-shadow: 0 25px 50px rgba(0,0,0,0.25);
            padding: 50px 40px;
            width: 100%;
            max-width: 420px;
        }
        .logo {
            text-align: center;
            margin-bottom: 35px;
        }
        .logo img {
            max-width: 220px;
            height: auto;
        }
        h1 {
            text-align: center;
            color: #1e40af;
            font-size: 26px;
            margin-bottom: 10px;
            font-weight: 700;
        }
        .subtitle {
            text-align: center;
            color: #64748b;
            margin-bottom: 35px;
            font-size: 14px;
        }
        label {
            display: block;
            color: #334155;
            font-weight: 600;
            margin-bottom: 10px;
            font-size: 14px;
        }
        input[type="password"] {
            width: 100%;
            padding: 14px 18px;
            border: 2px solid #e2e8f0;
            border-radius: 10px;
            font-size: 16px;
            transition: all 0.3s;
            font-family: monospace;
            letter-spacing: 3px;
        }
        input[type="password"]:focus {
            outline: none;
            border-color: #1e40af;
            box-shadow: 0 0 0 3px rgba(30, 64, 175, 0.1);
        }
        button {
            width: 100%;
            padding: 16px;
            background: linear-gradient(135deg, #1e3a8a 0%, #1e40af 100%);
            color: white;
            border: none;
            border-radius: 10px;
            font-size: 16px;
            font-weight: 700;
            cursor: pointer;
            margin-top: 25px;
            transition: all 0.3s;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        button:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(30, 64, 175, 0.3);
        }
        button:active {
            transform: translateY(0);
        }
        .error {
            background: #fee;
            color: #c53030;
            padding: 14px;
            border-radius: 10px;
            margin-top: 20px;
            text-align: center;
            border-left: 4px solid #c53030;
            animation: shake 0.5s;
        }
        @keyframes shake {
            0%, 100% { transform: translateX(0); }
            25% { transform: translateX(-10px); }
            75% { transform: translateX(10px); }
        }
        .lock-icon {
            text-align: center;
            font-size: 48px;
            margin-bottom: 20px;
            color: #1e40af;
        }
    </style>
</head>
<body>
    <div class="login-box">
        <div class="lock-icon">🔐</div>
        <div class="logo">
            <img src="<?= LOGO_URL ?>" alt="VAELSA Logo">
        </div>
        <h1>Cotizador VAELSA</h1>
        <p class="subtitle">Ingresa tu contraseña para acceder</p>
        
        <form method="POST">
            <label for="password">Contraseña de Acceso</label>
            <input 
                type="password" 
                id="password" 
                name="password" 
                placeholder="••••" 
                autofocus 
                required
                maxlength="4"
            >
            <button type="submit">Acceder al Sistema</button>
            
            <?php if ($error): ?>
                <div class="error">❌ <?= h($error) ?></div>
            <?php endif; ?>
        </form>
    </div>
</body>
</html>