<?php
// Autoload para clases Smalot\PdfParser\* ubicadas en libs/PdfParser/
spl_autoload_register(function ($class) {
    $prefix  = 'Smalot\\PdfParser\\';
    $baseDir = __DIR__ . '/PdfParser/'; // aquí están tus .php (Config.php, Document.php, etc.)

    if (strncmp($class, $prefix, strlen($prefix)) !== 0) return;

    $relative = substr($class, strlen($prefix));   // p.ej. "RawData\RawDataParser"
    $file = $baseDir . str_replace('\\','/',$relative) . '.php';
    if (is_file($file)) require_once $file;
});
