<?php
require_once 'auth.php';
header('Content-Type: text/html; charset=UTF-8');  // <— NUEVO
checkAuth();
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cotizador VAELSA</title>
    <link rel="stylesheet" href="assets/style.css">
</head>
<body>
    <div class="container">
        <header>
            <div class="header-content">
                <img src="<?= LOGO_URL ?>" alt="VAELSA" class="logo">
                <div class="header-text">
                    <h1>Generador de Cotizaciones</h1>
                    <p>Sistema de conversión automática de cotizaciones VDE</p>
                </div>
                <a href="?logout=1" class="btn-logout">🚪 Cerrar Sesión</a>
            </div>
        </header>

        <main>
            <!-- PASO 1: Subir PDF -->
            <div class="card">
                <div class="card-header">
                    <h2>📄 Paso 1: Subir Cotización del Proveedor (PDF)</h2>
                    <p>Arrastra o selecciona el archivo PDF de la cotización de VDE</p>
                </div>
                <form id="uploadForm" method="post" action="#" enctype="multipart/form-data">
                    <div class="upload-zone" id="dropZone">
                        <div class="upload-icon">📎</div>
                        <input type="file" id="pdfFile" name="pdf" accept=".pdf" required>
                        <p class="upload-text">Arrastra el PDF aquí o haz click para seleccionar</p>
                        <span class="file-name"></span>
                    </div>
                    <button type="submit" class="btn btn-primary" id="btnProcesar">
                        <span class="btn-icon">🔄</span> Procesar PDF
                    </button>
                </form>
                <div id="loadingPDF" class="loading" style="display:none;">
                    <div class="spinner"></div>
                    <p>Extrayendo información del PDF...</p>
                </div>
            </div>

            <!-- PASO 2: Datos de la cotización -->
            <div class="card" id="quotationData" style="display:none;">
                <div class="card-header">
                    <h2>✏️ Paso 2: Información de la Cotización</h2>
                    <p>Completa los datos generales de la cotización</p>
                </div>
                <form id="quotationForm">
                    <div class="form-grid">
                        <div class="form-group">
                            <label>Consecutivo <span class="required">*</span></label>
                            <input type="text" name="consecutivo" placeholder="COT-105995" required>
                            <small>Formato: COT-XXXXXX</small>
                        </div>
                        
                        <div class="form-group">
                            <label>Nombre del Vendedor <span class="required">*</span></label>
                            <input type="text" name="vendedor" value="Alejandro Vallejo Elizondo" required>
                        </div>
                        
                        <div class="form-group">
                            <label>Atención / Contacto <span class="required">*</span></label>
                            <input type="text" name="cliente_nombre" placeholder="Alberto Gonzalez" required>
                            <small>Nombre de la persona a quien va dirigida</small>
                        </div>
                        
                        <div class="form-group">
                            <label>Empresa del Cliente</label>
                            <input type="text" name="cliente_empresa" placeholder="Empresa ABC S.A. de C.V.">
                            <small>Opcional - Si no hay empresa, dejar en blanco</small>
                        </div>
                        
                        <div class="form-group">
                            <label>Fecha de Cotización <span class="required">*</span></label>
                            <input type="date" name="fecha" value="<?= date('Y-m-d') ?>" required>
                        </div>
                        
                        <div class="form-group">
                            <label>Tipo de Cambio USD → MXN <span class="required">*</span></label>
                            <input type="number" name="tipo_cambio" step="0.01" value="20.00" required>
                            <small>Precio del dólar para conversión</small>
                        </div>
                    </div>

                    <div class="form-group checkbox-group">
                        <label class="checkbox-label">
                            <input type="checkbox" name="margen_global" id="margenGlobal">
                            <span>Aplicar el mismo margen a todos los productos</span>
                        </label>
                        <input type="number" name="margen_global_valor" id="margenGlobalValor" 
                               step="0.01" placeholder="Ej: 15 para 15%" 
                               style="display:none; margin-top:15px;" class="form-control">
                        <small id="margenHelp" style="display:none;">El margen se calcula como: Precio USD / (1 - Margen/100). Ej: 15% = divide entre 0.85</small>
                    </div>

                    <div class="form-group checkbox-group">
                        <label class="checkbox-label">
                            <input type="checkbox" name="mostrar_precios_unitarios" id="mostrarPU" checked>
                            <span>Mostrar precios unitarios en la cotización final</span>
                        </label>
                    </div>
                </form>
            </div>

            <!-- PASO 3: Productos extraídos -->
            <div class="card" id="productsCard" style="display:none;">
                <div class="card-header">
                    <h2>🛠️ Paso 3: Productos y Configuración Final</h2>
                    <p>Revisa y ajusta los márgenes y tiempos de entrega por producto</p>
                </div>
                <div id="productsTable"></div>
                <button type="button" id="generateBtn" class="btn btn-success">
                    <span class="btn-icon">📄</span> Generar Cotización Word
                </button>
                <div id="loadingGenerate" class="loading" style="display:none;">
                    <div class="spinner"></div>
                    <p>Generando documento Word...</p>
                </div>
            </div>

            <!-- Resultado final -->
            <div class="card" id="resultCard" style="display:none;">
                <div class="card-header success">
                    <h2>✅ Cotización Generada Exitosamente</h2>
                </div>
                <div class="result-content">
                    <div class="success-icon">🎉</div>
                    <p>Tu cotización ha sido generada correctamente</p>
                    <a href="#" id="downloadLink" class="btn btn-download" download>
                        <span class="btn-icon">⬇️</span> Descargar Cotización
                    </a>
                    <button type="button" onclick="location.reload()" class="btn btn-secondary">
                        Nueva Cotización
                    </button>
                </div>
            </div>
        </main>

        <footer>
            <p>&copy; <?= date('Y') ?> VAELSA - Soluciones Hidráulicas | Sistema de Cotizaciones v1.0</p>
        </footer>
    </div>

    <script src="assets/script.js"></script>
</body>
</html>