<?php
/******************************************************
 * CONFIGURACIÓN COTIZADOR VAELSA
 ******************************************************/
session_start();
date_default_timezone_set('America/Monterrey');

// Seguridad
define('PASSWORD', '1102');

// Rutas
define('BASE_DIR', __DIR__);
define('UPLOAD_DIR', BASE_DIR . '/uploads/');
define('OUTPUT_DIR', BASE_DIR . '/output/');
define('LIBS_DIR', BASE_DIR . '/libs/');

// VDE
define('VDE_BASE', 'https://www.vde.com.mx');

// VAELSA - Logo
define('LOGO_URL', 'http://bombasvaelsa.com/wp-content/uploads/VAELSA-C24-10-1-e1706029308806.png');

// VAELSA - Datos fijos
define('EMPRESA_NOMBRE', 'Soluciones Hidráulicas VAEL, S.A. de C.V.');
define('EMPRESA_DIRECCION', 'Mariano Salas No. 1102, Col. Los Altos, Escobedo, N.L.');
define('EMPRESA_TELEFONO', 'Tel. 83974900 / 84790539');
define('EMPRESA_WHATSAPP', '8118615633');
define('EMPRESA_EMAIL', 'vaelsagroup@gmail.com');

// Crear directorios si no existen
if (!file_exists(UPLOAD_DIR)) mkdir(UPLOAD_DIR, 0755, true);
if (!file_exists(OUTPUT_DIR)) mkdir(OUTPUT_DIR, 0755, true);

// Funciones auxiliares
function h($str) {
    return htmlspecialchars($str ?? '', ENT_QUOTES, 'UTF-8');
}

function formatMoney($amount) {
    return '$' . number_format($amount, 2, '.', ',') . ' MXN';
}

function formatQty($qty) {
    $formatted = number_format($qty, 2, '.', ',');
    return rtrim(rtrim($formatted, '0'), '.');
}

function getUnit($unit, $qty) {
    $unit = strtoupper(trim($unit));
    $qty = (float)$qty;
    
    $map = [
        'PIEZA' => ($qty == 1) ? 'PIEZA' : 'PIEZAS',
        'PIEZAS' => ($qty == 1) ? 'PIEZA' : 'PIEZAS',
        'METRO' => ($qty == 1) ? 'METRO' : 'METROS',
        'METROS' => ($qty == 1) ? 'METRO' : 'METROS',
        'LITRO' => ($qty == 1) ? 'LITRO' : 'LITROS',
        'LITROS' => ($qty == 1) ? 'LITRO' : 'LITROS',
        'JUEGO' => ($qty == 1) ? 'JUEGO' : 'JUEGOS',
        'SERVICIO' => ($qty == 1) ? 'SERVICIO' : 'SERVICIOS',
    ];
    
    return $map[$unit] ?? $unit;
}

function cleanText($text) {
    $text = trim($text);
    $text = preg_replace('/\s+/', ' ', $text);
    return $text;
}
?>